#include <iostream>
#include <vector>
#include <algorithm>
#include <map>

using namespace std;

typedef long long ll;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    ll n;
    int k;
    cin >> n >> k;

    vector<ll> d(k);
    map<ll, ll> f; // f[delilac] = trenutna xor suma
    for (int i = 0; i < k; i++) {
        cin >> d[i];
        f[d[i]] = d[i]; // Inicijalno f(x) = x
    }

    // Nalazimo proste cinioce broja n
    vector<ll> prosti;
    ll temp_n = n;
    for (ll i = 2; i * i <= temp_n; i++) {
        if (temp_n % i == 0) {
            prosti.push_back(i);
            while (temp_n % i == 0) temp_n /= i;
        }
    }
    if (temp_n > 1) prosti.push_back(temp_n);

    // SOS DP logike preko delilaca (Dirichlet XOR sum)
    // Redosled delilaca je bitan za in-place azuriranje
    vector<ll> sortirani_d = d;
    sort(sortirani_d.begin(), sortirani_d.end());

    for (ll p : prosti) {
        for (ll x : sortirani_d) {
            if (x % p == 0) {
                // Ako x deli p, dodajemo XOR vrednost f(x/p) u f(x)
                // f(x) = f(x) XOR f(x/p)
                f[x] ^= f[x / p];
            }
        }
    }

    // Ispisujemo rezultate u originalnom redosledu
    for (int i = 0; i < k; i++) {
        cout << f[d[i]] << (i == k - 1 ? "" : " ");
    }
    cout << endl;

    return 0;
}